/*****************************************************************************
* Radio Utility Application for KW01 - Header file
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
***************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***********************************************************************************************//*!
**************************************************************************************************/

#ifndef RADIOUTILITY_H_
#define RADIOUTILITY_H_

 extern void RadioUtilty(void); 
extern void UartTxCallBack(uint8_t *pBuf);       
//extern void UartTxCallBack(uint8_t const *pBuf);   
 extern void RadioUtilityUartRxCallback(uint8_t *ptrUartRxData);
 extern void RadioUtility_InitVariables(void);
 extern void RadioUtility_MCPSDataConfirm(void);

/* Transceiver services */
#define gRfFreq_c 					( 0x11 )
#define gBitrate_c 					( 0x12 )
#define gFreqDev_c					( 0x13 )
#define gSequencer_c 				( 0x14 )
#define gDataMode_c					( 0x20 )
#define gModulationType_c			( 0x30 )
#define gModulationShaping_c		( 0x40 )
#define gPowerAmplifierOutput_c 	( 0x51 )
#define gPaRamp_c					( 0x54 )
#define gOutputPower_c				( 0x61 )
#define gRxBwDccFreq_c				( 0x71 )
#define gRxBwFilterBw_c				( 0x72 )
#define gAfcDccFreq_c				( 0x81 )
#define gAfcFilterBw_c				( 0x82 )
#define gOokThresholdType_c			( 0x91 )
#define gOokPeakThresholdStep_c		( 0x92 )
#define gOokPeakThresholdDec_c		( 0x93 )
#define gOokAvgThresholdCutoff_c	( 0x94 )
#define gOokFixedThreshold_c		( 0x95 )
#define gAfcLowBeta_c				( 0xA1 )
#define gAfcLowBetaOffset_c			( 0xA2 )
#define gAfcAutoClear_c				( 0xA3 )
#define gAfcAuto_c					( 0xA4 )
#define gClearAfc_c					( 0xA7 )              
#define gAfcValue_c					( 0xA5 )              /* Return value */
#define gFeiValue_c					( 0xA6 )			  /* Return value */
#define gRssiTimeoutRxStart_c		( 0xB1 )
#define gRssiTimeoutThreshold_c		( 0xB2 )
#define gRssiThreshold_c			( 0xB4 )
#define gRssiValue_c				( 0xB5 )			  /* Return value */
#define gInputImpedance_c			( 0xC1 )
#define gSensitivityBoost_c			( 0xC2 )
#define gRestartRx_c				( 0xE0 )
#define gReadReg_c					( 0x5D )
#define gWriteReg_c					( 0x5E )

/* Uart packets' identificators */
#define gHeaderMsb_c				( 0xAA )
#define gHeaderLsb_c				( 0xFF )

/* On-Off code for services */
#define gOn_c						( 0xDD )
#define gOff_c						( 0xBB )

/* Default Radio Registers Values */
#define gDefaultOperationMode_c		( OpMode_StandBy )
#define gDefaultRfFreq_c			( 0xE4C000 )
#define gDefaultBitRate_c			( 0x1A0B )
#define gDefaultFreqDv_c			( 0x0052 )
#define gDefaultSequencer_c			( OpMode_Sequencer_On )
#define gDefaultDataMode_c			( DataModul_DataMode_Packet )
#define gDefaultModulationType_c	( DataModul_Modulation_Fsk )
#define gDefaultModulationShaping_c	( DataModul_ModulationShaping_NoShaping )
#define gDefaultPowerAmpMode_c		( PaLevel_Pa0_On )
#define gDefaultPaRamp_c			( 0x09 )
#define gDefaultDccFreq_c			( DccFreq_2 )
#define gDefaultRxFilterBw_c		( RxBw_10400 )
#define gDefaultDccFreqAfc_c		( DccFreq_4 )
#define gDefaultRxFilterBwAfc_c		( RxBw_50000 )
#define gDefaultOokThresType_c		( OokThreshType_Peak )
#define gDefaultOokFixedThres_c		( 0x06 )
#define gDefaultOokPeakThresStep_c	( OokPeakThreshStep_0_5dB )
#define gDefaultOokPeakThresDec_c	( OokPeakThreshDec_OncePerChip )
#define gDefaultOokAvgThreshFilt_c	( OokAvgThreshFilt_382 )
#define gDefaultAfcLowBeta_c		( FALSE )
#define gDefaultLowBetaOffset_c		( 0x00 )
#define gDefaultAfcAutoClear_c		( FALSE )
#define gDefaultAfcAuto_c			( FALSE )
#define gDefaultRxTimeout_c 		( 0x00 )
#define gDefaultRxTimeoutThresh_c	( 0x00 )
#define gDefaultRssiThresh_c		( 0xFF )
#define gDefaultLnaImputImpedance_c	( Lna_LnaZin_200 )
#define gDefaultSensitivityBoost_c	( NormalSensitivity )
#define gDefaultLnaGain_c			( 0x88 ) 
#define gDefaultFifoThresh_c        ( 0x8F ) 
#define gDefaultSyncValue_c         ( 0x01 ) 

#define gReset_c 					( 'R' )


typedef enum radioUtilityStates_tag{
	gInitialState_c = 0,
	gAppState_c,
	gMaxState_c
}radioUtilityStates_t;
 


#endif /* RADIOUTILITY_H_ */
